{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:19:57 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Forms, ExtCtrls, StdCtrls,
  Buttons, Controls, Classes, Graphics, MPlayer, MMSystem, MMUtils, MMObj,
  MMWavIn, MMLEDS, MMLevel, MMLEDLbl, MMDIBCv, MMOscope, MMWave, MMSpin,
  MMSwitch, MMSpectr, MMConect, MMDesign, MMDSPObj, MMSlider, MMHook;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    LED1: TMMLED;
    Label7: TLabel;
    LED2: TMMLED;
    Label8: TLabel;
    LED3: TMMLED;
    Label9: TLabel;
    LED4: TMMLED;
    Label10: TLabel;
    Oscope1: TMMOscope;
    Oscope2: TMMOscope;
    MMLEDLabel1: TMMLEDLabel;
    Display1: TPanel;
    tt2: TMMLEDDigit;
    tt: TMMLEDDigit;
    mm2: TMMLEDDigit;
    mm: TMMLEDDigit;
    ss2: TMMLEDDigit;
    ss: TMMLEDDigit;
    Colon1: TMMLEDDigit;
    Level2: TMMLevel;
    Level1: TMMLevel;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CheckBox1: TCheckBox;
    MediaPlayer1: TMediaPlayer;
    CheckBox2: TCheckBox;
    UseBackGround1: TBitBtn;
    UseBackGround2: TBitBtn;
    MMWaveIn1: TMMWaveIn;
    Label11: TLabel;
    Label12: TLabel;
    SpinEdit6: TMMLEDSpin;
    SpinEdit7: TMMLEDSpin;
    SpinEdit4: TMMLEDSpin;
    SpinEdit5: TMMLEDSpin;
    SpinEdit8: TMMLEDSpin;
    Label13: TLabel;
    MMLEDPanel1: TMMLEDPanel;
    Label18: TLabel;
    MMLEDPanel2: TMMLEDPanel;
    Label19: TLabel;
    GroupBox3: TGroupBox;
    MMLEDPanel3: TMMLEDPanel;
    Label20: TLabel;
    MMLEDMode1: TMMLEDMode;
    Overflow1: TLabel;
    CheckBox4: TCheckBox;
    SpinDeviceID: TMMSpinButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label14: TLabel;
    SpinEdit3: TMMLEDSpin;
    SpinEdit2: TMMLEDSpin;
    SpinEdit1: TMMLEDSpin;
    StopButton: TSpeedButton;
    StartButton: TSpeedButton;
    Timer1: TTimer;
    MMSwitch2: TMMSwitch;
    MMSwitch1: TMMSwitch;
    Label24: TLabel;
    Label25: TLabel;
    CheckBox5: TCheckBox;
    Spectrum1: TMMSpectrum;
    Spectrum2: TMMSpectrum;
    GroupBox4: TGroupBox;
    Label15: TLabel;
    Label16: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label17: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    SpinEdit9: TMMLEDSpin;
    Label29: TLabel;
    MMLEDSpin3: TMMLEDSpin;
    Label31: TLabel;
    MMLEDSpin6: TMMLEDSpin;
    Label30: TLabel;
    MMLEDSpin1: TMMLEDSpin;
    Kind: TLabel;
    MMSwitch3: TMMSwitch;
    Label32: TLabel;
    MMSwitch4: TMMSwitch;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    SlideBar1: TMMSlider;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    ckBShowPeak: TCheckBox;
    Label45: TLabel;
    MMSwitch5: TMMSwitch;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    MMConnector1: TMMConnector;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    LevelScale: TMMLevelScale;
    ckBLogAmp: TCheckBox;
    MMDesigner1: TMMDesigner;
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ExitButtonClick(Sender: TObject);
    procedure OscopeClick(Sender: TObject);
    procedure OscopeDblClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure GainOverflow(Sender: TObject);
    procedure LevelClick(Sender: TObject);
    procedure LevelDblClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
    procedure LevelGainOverflow(Sender: TObject);
    procedure UseBackGroundClick(Sender: TObject);
    procedure DrawTracks;
    procedure CheckBox2Click(Sender: TObject);
    procedure PcmOverflow(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure DisplayDblClick(Sender: TObject);
    procedure SpinEdit8Change(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure MMWaveIn1Start(Sender: TObject);
    procedure MMWaveIn1Stop(Sender: TObject);
    procedure MMWaveIn1Close(Sender: TObject);
    procedure MMWaveIn1Open(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure MMSwitch2Change(Sender: TObject);
    procedure MMSwitch1Change(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure SpinEdit9DownClick(Sender: TObject);
    procedure SpinEdit9UpClick(Sender: TObject);
    procedure MMLEDSpin3DownClick(Sender: TObject);
    procedure MMLEDSpin3UpClick(Sender: TObject);
    procedure MMLEDSpin6DownClick(Sender: TObject);
    procedure MMLEDSpin6UpClick(Sender: TObject);
    procedure MMLEDSpin1Change(Sender: TObject);
    procedure MMSwitch4Change(Sender: TObject);
    procedure MMSwitch3Change(Sender: TObject);
    procedure SlideBar1Change(Sender: TObject);
    procedure ckBShowPeakClick(Sender: TObject);
    procedure SpectrumClick(Sender: TObject);
    procedure SpectrumDblClick(Sender: TObject);
    procedure MMSwitch5Change(Sender: TObject);
    procedure MMConnector1Trigger(Sender: TObject);
    procedure ckBLogAmpClick(Sender: TObject);
    procedure SpinDeviceIDChange(Sender: TObject);
  public
    LowestDevice: integer;
    OverFlow: Boolean;
    ShowFPS: Boolean;
    UpdateTracks: Boolean;
    oldRefreshCount: integer;
    oTrack, oMin, oSec: Byte;                  { saved cd-position values }

    oldNumPeaks: integer;                            { saved level values }
    oldSpotWidth: integer;

    procedure SetNewWaveParams;
    procedure UpdateDisplay;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetNewWaveParams;
begin
   { make sure the buffer is not to less }
   if (MMWaveIn1.BufferSize < Max(Oscope1.BytesPerScope,Spectrum1.BytesPerSpectrum)) then
      MMWaveIn1.BufferSize := Max(Oscope1.BytesPerScope,Spectrum1.BytesPerSpectrum);

   UpdateDisplay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StartButtonClick(Sender: TObject);
begin
   if (MMWaveIn1.NumDevs = 0) then
       Application.MessageBox('Sorry, No WaveIn device installed!',
                                 'WaveIn open error',mb_OK OR mb_IconStop)
   else
   begin
      try
         MMWaveIn1.Start;
         StartButton.Down := True;

      except
         StartButton.Down := False;
         raise;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StopButtonClick(Sender: TObject);
begin
     MMWaveIn1.Stop;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
     try
        { look if we have a CD-ROM drive }
        MediaPlayer1.Open;
     except
        MediaPlayer1.EnabledButtons := [];
        Colon1.Enabled := False;
        ss.Enabled  := False;
        ss2.Enabled := False;
        mm.Enabled  := False;
        mm2.Enabled := False;
        tt.Enabled  := False;
        tt2.Enabled := False;
     end;

     MMConnector1.Speed := SlideBar1.Position;
     UpdateTracks := True;
     ShowFPS := False;
     OldRefreshCount := 0;
     Overflow := False;

     MMWaveIn1.DeviceID := 0;
     { is the Wave Mapper istalled ? }
     LowestDevice := WAVE_MAPPER;                           { WAVE MAPPER }
     try
        MMWaveIn1.DeviceID := WAVE_MAPPER;
     except
         { disable stop on exceptions when in designer , this is not a bug !! }
         On EMMWaveInError do LowestDevice := 0;  { WAVE MAPPER not inst. }
     end;
     MMWaveIn1.DeviceID := LowestDevice;

     { set the logic for the device spinedit }
     if (MMWaveIn1.NumDevs > 1) or (LowestDevice = WAVE_MAPPER) then
     begin
          SpinDeviceId.Enabled := True;
          SpinDeviceId.MinValue := LowestDevice;
          SpinDeviceID.MaxValue := MMWaveIn1.NumDevs-1;
          SpinDeviceID.Value := MMWaveIn1.DeviceID;
     end
     else SpinDeviceId.Enabled := False;

     SetNewWaveParams;

     { make sure we do not overflow the buffer with zoom in (GPF!!) }
     SpinEdit2.MaxValue := MMWaveIn1.BufferSize div Oscope1.BytesPerScope;

     oTrack := 0;
     oMin := 0;
     oSec := 0;

     { fix the cd-player width! }
     MediaPlayer1.Width := Display1.Width;

     StopButton.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Timer1.Enabled := False;
     MMWaveIn1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinDeviceIDChange(Sender: TObject);
begin
   MMWaveIn1.DeviceID := SpinDeviceID.Value;
   UpdateDisplay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeClick(Sender: TObject);
Var
   Temp: TMMOscopeKind;

begin
     if Sender = Oscope1 then
     begin
          Temp := Oscope1.Kind;
          if (Temp = okSpikes) then Temp := okDots
          else inc(Temp);
          Oscope1.Kind := Temp;
     end
     else
     begin
          Temp := Oscope2.Kind;
          if (Temp = okSpikes) then Temp := okDots
          else inc(Temp);
          Oscope2.Kind := Temp;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeDblClick(Sender: TObject);
begin
     Oscope1.Enabled := NOT Oscope1.Enabled;
     Oscope2.Enabled := NOT Oscope2.Enabled;
     CheckBox5.Checked := Oscope1.Enabled;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelClick(Sender: TObject);
begin
     if (Level1.SpotWidth > 2) then
     begin
          Level1.NumPeaks   := oldNumPeaks;
          Level1.SpotWidth  := oldSpotWidth;
          Level2.SpotWidth  := oldSpotWidth;
          SpinEdit8.MaxValue := 5;
          SpinEdit8.Value  := oldNumPeaks;
     end
     else
     begin
          oldSpotWidth  := Level1.SpotWidth;
          oldNumPeaks   := SpinEdit8.Value;
          SpinEdit8.MaxValue := 1;
          SpinEdit8.Value := 1;
          Level1.SpotWidth  := 6;
          Level2.SpotWidth  := 6;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelDblClick(Sender: TObject);
begin
     Level1.Enabled := NOT Level1.Enabled;
     Level2.Enabled := NOT Level2.Enabled;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpectrumClick(Sender: TObject);
Var
   Temp: TMMSpectrumKind;

begin
   if Sender = Spectrum1 then
   begin
      Temp := Spectrum1.Kind;
      if (Temp = skPeaks) then Temp := skDots
      else inc(Temp);
      Spectrum1.Kind := Temp;
   end
   else
   begin
      Temp := Spectrum2.Kind;
      if (Temp = skPeaks) then Temp := skDots
      else inc(Temp);
      Spectrum2.Kind := Temp;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpectrumDblClick(Sender: TObject);
begin
   Spectrum1.Enabled := NOT Spectrum1.Enabled;
   Spectrum2.Enabled := NOT Spectrum2.Enabled;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawTracks;
var
   PlayerPos: Longint;
   Track, Min, Sec: Byte;

begin
     if MediaPlayer1.DeviceID <> 0 then
        PlayerPos := MediaPlayer1.Position
     else
        PlayerPos := 0;

     Track := mci_TMSF_Track(PlayerPos);
     if (Track <> oTrack) then
     begin
          tt.Value := Track;
          oTrack := Track;
     end;

     Min := mci_TMSF_Minute(PlayerPos);
     if (Min <> oMin) then
     begin
          mm.Value := Min;
          oMin := Min;
     end;

     Sec := mci_TMSF_Second(PlayerPos);
     if (Sec <> oSec) then
     begin
          ss .Value := Sec;
          oSec := Sec;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMConnector1Trigger(Sender: TObject);
begin
     { we use OnTrigger only to reset the Overflow flag }
     if Overflow then
     begin
        LED1.Enabled := False;
        LED2.Enabled := False;
        LED3.Enabled := False;
        LED4.Enabled := False;
        Overflow1.Font.Color := clBlack;
        Overflow := False;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Timer1Timer(Sender: TObject);
Var
   Temp: Longint;

begin
     if ShowFPS AND (MMConnector1.RefreshCountOscope <> OldRefreshCount) then
     begin
          Temp := MMConnector1.RefreshCountOscope;
          CheckBox2.Caption := ' ' + IntToStr(Temp) + ' frames/s';
          OldRefreshCount := Temp;
     end;
     MMConnector1.RefreshCountOscope := 0;

     if UpdateTracks then DrawTracks;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit1Change(Sender: TObject);
begin
     Oscope1.Steps := SpinEdit1.Value;
     Oscope2.Steps := SpinEdit1.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit2Change(Sender: TObject);
begin
     if (SpinEdit2.Value = 0) then
        if (Oscope1.Zoom < 0) then SpinEdit2.Value := 1
        else SpinEdit2.Value := -1;

     Oscope1.Zoom := SpinEdit2.Value;
     Oscope2.Zoom := SpinEdit2.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit3Change(Sender: TObject);
begin
   Oscope1.Gain := SpinEdit3.Value;
   Oscope2.Gain := SpinEdit3.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.LevelGainOverflow(Sender: TObject);
begin
   Overflow := True;
   if (Sender = Level1) then LED2.Enabled := True
   else LED4.Enabled := True;
   Overflow1.Font.Color := clRed;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.GainOverflow(Sender: TObject);
begin
   Overflow := True;
   if (Sender = Oscope1) or (Sender = Spectrum1) then LED2.Enabled := True
   else LED4.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PcmOverflow(Sender: TObject);
begin
   Overflow := True;
   if (Sender = Oscope1) OR (Sender = Level1) or (Sender = Spectrum1) then
       LED1.Enabled := True
   else LED3.Enabled := True;
   if (Sender = Level1) OR (Sender = Level2) then Overflow1.Font.Color := clRed;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.UpdateDisplay;
begin
   if (MMWaveIn1.NumDevs = 0) then MMLEDLabel1.Caption := 'NO DEVICE INSTALLED!'
   else MMLEDLabel1.Caption := UpperCase(MMWaveIn1.ProductName);

   MMLEDPanel1.Value := MMWaveIn1.SampleRate;

   if (MMWaveIn1.BitLength = b8bit) then MMLEDPanel2.Value := 8
   else MMLEDPanel2.Value := 16;

   MMLEDMode1.Mode := MMWaveIn1.Mode;

   MMLEDPanel3.Value := MMWaveIn1.NumBuffers;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
   Level1.Enabled := CheckBox1.Checked;
   Level2.Enabled := CheckBox1.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox2Click(Sender: TObject);
begin
   ShowFPS := CheckBox2.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox4Click(Sender: TObject);
begin
   Level1.ActiveDoted := NOT Level1.ActiveDoted;
   Level2.ActiveDoted := NOT Level2.ActiveDoted;
   Level1.InactiveDoted := NOT Level1.InactiveDoted;
   Level2.InactiveDoted := NOT Level2.InactiveDoted;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit4Change(Sender: TObject);
begin
   Level1.PeakSpeed := SpinEdit4.Value;
   Level2.PeakSpeed := SpinEdit4.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit5Change(Sender: TObject);
begin
   Level1.Gain := SpinEdit5.Value;
   Level2.Gain := SpinEdit5.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit6Change(Sender: TObject);
begin
   Level1.PeakDelay := SpinEdit6.Value;
   Level2.PeakDelay := SpinEdit6.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit7Change(Sender: TObject);
begin
   Level1.Decay := SpinEdit7.Value;
   Level2.Decay := SpinEdit7.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit8Change(Sender: TObject);
begin
   Level1.NumPeaks := SpinEdit8.Value;
   Level2.NumPeaks := SpinEdit8.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.UseBackGroundClick(Sender: TObject);
begin
   if Sender = UseBackGround1 then
   begin
      if (NOT Oscope1.BackGroundDIB.Empty) then
      begin
         Oscope1.UseBackGroundDIB := NOT Oscope1.UseBackGroundDIB;
         Oscope1.PaletteRealize := Oscope1.UseBackGroundDIB;
         if Oscope1.UseBackGroundDIB then UseBackGround1.Caption := 'Background DIB: On'
         else UseBackGround1.Caption := 'Background DIB: Off';
      end;
   end
   else
   begin
      if (NOT Oscope2.BackGroundDIB.Empty) then
      begin
         Oscope2.UseBackGroundDIB := NOT Oscope2.UseBackGroundDIB;
         Oscope2.PaletteRealize := Oscope2.UseBackGroundDIB;
         if Oscope2.UseBackGroundDIB then UseBackGround2.Caption := 'Background DIB: On'
         else UseBackGround2.Caption := 'Background DIB: Off';
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DisplayDblClick(Sender: TObject);
begin
   if MediaPlayer1.DeviceID <> 0 then
   begin
      UpdateTracks := NOT UpdateTracks;
      Colon1.Enabled := UpdateTracks;
      ss.Enabled  := UpdateTracks;
      ss2.Enabled := UpdateTracks;
      mm.Enabled  := UpdateTracks;
      mm2.Enabled := UpdateTracks;
      tt.Enabled  := UpdateTracks;
      tt2.Enabled := UpdateTracks;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveIn1Open(Sender: TObject);
begin
   SpinDeviceId.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveIn1Close(Sender: TObject);
begin
   if (MMWaveIn1.NumDevs > 1) or (LowestDevice = WAVE_MAPPER) then
       SpinDeviceId.Enabled := True
   else SpinDeviceId.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveIn1Start(Sender: TObject);
begin
   StartButton.Down := True;
   StopButton.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveIn1Stop(Sender: TObject);
begin
   MMWaveIn1.Close;
   StartButton.Down := False;
   StopButton.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch1Change(Sender: TObject);
begin
   Oscope1.Kind := TMMOscopeKind(MMSwitch1.Position);
   Oscope2.Kind := TMMOscopeKind(MMSwitch1.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch2Change(Sender: TObject);
begin
   Oscope1.Effect := TMMOscopeEffect(MMSwitch2.Position);
   Oscope2.Effect := TMMOscopeEffect(MMSwitch2.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBox5Click(Sender: TObject);
begin
   Oscope1.Enabled := CheckBox5.Checked;
   Oscope2.Enabled := CheckBox5.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit9DownClick(Sender: TObject);
begin
   Spectrum1.FFTLength := Spectrum1.FFTLength div 2;
   Spectrum2.FFTLength := Spectrum2.FFTLength div 2;
   SpinEdit9.Value := Spectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinEdit9UpClick(Sender: TObject);
begin
   Spectrum1.FFTLength := Spectrum1.FFTLength * 2;
   Spectrum2.FFTLength := Spectrum2.FFTLength * 2;
   SpinEdit9.Value := Spectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin3DownClick(Sender: TObject);
var
   Factor: integer;

begin
   if (Spectrum1.VerticalScale > 10) then Factor := 5
   else Factor := 1;

   Spectrum1.VerticalScale := Spectrum1.VerticalScale - Factor;
   Spectrum2.VerticalScale := Spectrum2.VerticalScale - Factor;
   MMLEDSpin3.Value := Spectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin3UpClick(Sender: TObject);
var
   Factor: integer;

begin
   if (Spectrum1.VerticalScale < 10) then Factor := 1
   else Factor := 5;

   Spectrum1.VerticalScale := Spectrum1.VerticalScale + Factor;
   Spectrum2.VerticalScale := Spectrum2.VerticalScale + Factor;
   MMLEDSpin3.Value := Spectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin6DownClick(Sender: TObject);
begin
   Spectrum1.FrequencyScale := Spectrum1.FrequencyScale div 2;
   Spectrum2.FrequencyScale := Spectrum2.FrequencyScale div 2;
   MMLEDSpin6.Value := Spectrum1.FrequencyScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin6UpClick(Sender: TObject);
begin
   Spectrum1.FrequencyScale := Spectrum1.FrequencyScale * 2;
   Spectrum2.FrequencyScale := Spectrum2.FrequencyScale * 2;
   MMLEDSpin6.Value := Spectrum1.FrequencyScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin1Change(Sender: TObject);
begin
   Spectrum1.Decay := MMLEDSpin1.Value;
   Spectrum2.Decay := MMLEDSpin1.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch4Change(Sender: TObject);
begin
   Spectrum1.DecayMode := TMMDecayMode(MMSwitch4.Position+1);
   Spectrum2.DecayMode := TMMDecayMode(MMSwitch4.Position+1);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch3Change(Sender: TObject);
begin
   Spectrum1.Kind := TMMSpectrumKind(MMSwitch3.Position);
   Spectrum2.Kind := TMMSpectrumKind(MMSwitch3.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch5Change(Sender: TObject);
begin
   Level1.DecayMode := TMMDecayMode(MMSwitch5.Position);
   Level2.DecayMode := TMMDecayMode(MMSwitch5.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SlideBar1Change(Sender: TObject);
begin
   MMConnector1.Speed := SlideBar1.Position;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBShowPeakClick(Sender: TObject);
begin
   Spectrum1.DisplayPeak := ckBShowPeak.Checked;
   Spectrum2.DisplayPeak := ckBShowPeak.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBLogAmpClick(Sender: TObject);
begin
   Spectrum1.LogAmp := ckBLogAmp.Checked;
   Spectrum2.LogAmp := ckBLogAmp.Checked;
end;

end.



